﻿namespace Code6587EN.Ch06.ConfigureGroupsAndTerms
{
    using Microsoft.SharePoint;
using Microsoft.SharePoint.Administration;
using Microsoft.SharePoint.Taxonomy;
using System;

    /// <summary>
    /// Console Application to create metadata groups and terms
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Open the Site Collection that will contain the new Publishing Site
            using (var site = new SPSite("http://sharepoint/publishing"))
            {
                // Open a new taxonomy session from the site collection
	            var session = new TaxonomySession(site);
	
	            // Get the first term store in the session
	            var termStore = session.TermStores[0];

	            // Create the Code Product Categories group
	            var group = termStore.CreateGroup("Code Product Categories");

	            // Create the Products term set
	            var termSet = group.CreateTermSet("Products");

	            // Create the Widgets term in the Products term set
	            var widgets = termSet.CreateTerm("Widgets", 1033);

	            // Create the Red, Green, and Blue terms in the Widgets term
	            widgets.CreateTerm("Red", 1033);
	            widgets.CreateTerm("Green", 1033);
	            widgets.CreateTerm("Blue", 1033);

	            // Commit the changes to the term store
	            termStore.CommitAll();
            }

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
